package com.ejie.ab04b.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.TipoExpedienteFolderEnum;
import com.ejie.ab04b.dao.NumeracionExpedienteDao;
import com.ejie.ab04b.dao.OS2Dao;
import com.ejie.ab04b.dao.temp.DocumentosOS2TempDao;
import com.ejie.ab04b.exception.ErrorField;
import com.ejie.ab04b.exception.ErrorGenericoException;
import com.ejie.ab04b.model.ComunicacionPrl;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.DatosNotificacion;
import com.ejie.ab04b.model.DocumentoOS2;
import com.ejie.ab04b.model.NumeracionExpediente;
import com.ejie.ab04b.model.OS2;
import com.ejie.ab04b.service.platea.ReeService;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.ct.xml.FolderDocumentList;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * OS2ServiceImpl generated by UDA, 28-feb-2017 16:03:08.
 * 
 * @author UDA
 */

@Service(value = "OS2Service")
public class OS2ServiceImpl implements OS2Service {

	@Autowired()
	private OS2Dao os2Dao;

	@Autowired()
	private DatosLocalizacionService datosLocalizacionService;

	@Autowired()
	private DatosNotificacionService datosNotificacionService;

	@Autowired()
	private NumeracionExpedienteDao numeracionExpedienteDao;

	@Autowired()
	private DocumentosOS2TempDao documentosOS2TempDao;

	@Autowired()
	private ReeService reeService;

	/**
	 * Inserts a single row in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 Ab0460s00
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @return the os2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS2 add(OS2 ab0460s00) {
		return this.os2Dao.add(ab0460s00);
	}

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 Ab0460s00
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @return the os2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS2 update(OS2 ab0460s00) {
		return this.os2Dao.update(ab0460s00);
	}

	/**
	 * Finds a single row in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 Ab0460s00
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @return the os2
	 */
	public OS2 find(OS2 ab0460s00) {
		return (OS2) this.os2Dao.find(ab0460s00);
	}

	/**
	 * Deletes a single row in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(OS2 ab0460s00) {
		this.os2Dao.remove(ab0460s00);
	}

	/**
	 * Finds a list of rows in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 jqGridRequestDto JQGridRequestDto List<Ab0460s00>
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	public List<OS2> findAll(OS2 ab0460s00, JQGridRequestDto jqGridRequestDto) {
		return (List<OS2>) this.os2Dao.findAll(ab0460s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0460s00 table using like.
	 * 
	 * ab0460s00 Ab0460s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0460s00>
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<OS2> findAllLike(OS2 ab0460s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<OS2>) this.os2Dao.findAllLike(ab0460s00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Finds a list of rows in the Ab0427s00 table.
	 * 
	 * ab0427s00 Ab0427s00
	 * 
	 * List<Ab0427s00>
	 * 
	 * @param ab0427s00
	 *            the ab 0427 s 00
	 * @return the list
	 */
	public List<DocumentoOS2> findAllDocumentosOS2TipoTemp(
			DocumentoOS2 ab0427s00) {
		return (List<DocumentoOS2>) this.documentosOS2TempDao
				.buscarDocumentosOS2TempTipo(ab0427s00);
	}

	/**
	 * Finds a list of rows in the Ab0427s00 table.
	 * 
	 * ab0465s00 Ab0427s00
	 * 
	 * List<Ab0427s00>
	 * 
	 * @param ab0427s00
	 *            the ab 0427 s 00
	 * @return the list
	 */
	/*
	 * public List<DocumentoOS2> findAll(DocumentoOS2 ab0427s00) { return
	 * (List<DocumentoOS2>) this.documentosOS2TempDao
	 * .buscarDocumentosOS2TempTipo(ab0427s00); }
	 */

	/**
	 * Finds a list of rows in the Ab0427s00 table.
	 * 
	 * ab0465s00 Ab0427s00
	 * 
	 * List<Ab0427s00>
	 * 
	 * @param ab0427s00
	 *            the ab 0427 s 00
	 * @return the list
	 */
	public List<DocumentoOS2> buscarDocumentosOS2Temp(DocumentoOS2 ab0427s00) {
		return (List<DocumentoOS2>) this.documentosOS2TempDao
				.buscarDocumentosOS2Temp(ab0427s00);
	}

	/**
	 * Finds a list of rows in the Ab0460s00 table.
	 * 
	 * ab0460s00 Ab0460s00 jqGridRequestDto JQGridRequestDto List<Ab0460s00>
	 * 
	 * @param ab0460s00
	 *            the ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	public List<DocumentoOS2> findAll(DocumentoOS2 ab0427s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<DocumentoOS2>) this.documentosOS2TempDao.findAll(
				ab0427s00, jqGridRequestDto);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0460s00 table.
	 * 
	 * filterAb0460s00 Ab0460s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<Ab0460s00>
	 * 
	 * @param filterAb0460s00
	 *            the filter ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<OS2> filter(OS2 filterAb0460s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<OS2> listaAb0460s00 = this.os2Dao.findAllLike(filterAb0460s00,
				jqGridRequestDto, false);
		Long recordNum = this.os2Dao.findAllLikeCount(
				filterAb0460s00 != null ? filterAb0460s00 : new OS2(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<OS2>> reorderSelection = this.os2Dao
					.reorderSelection(filterAb0460s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<OS2>(jqGridRequestDto, recordNum,
					listaAb0460s00, reorderSelection);
		}
		return new JQGridResponseDto<OS2>(jqGridRequestDto, recordNum,
				listaAb0460s00);
	}

	/**
	 * Searches rows in the Ab0460s00 table.
	 * 
	 * filterAb0460s00 Ab0460s00 searchAb0460s00 Ab0460s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0460s00>>
	 * 
	 * @param filterAb0460s00
	 *            the filter ab 0460 s 00
	 * @param searchAb0460s00
	 *            the search ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<TableRowDto<OS2>> search(OS2 filterAb0460s00,
			OS2 searchAb0460s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.os2Dao.search(filterAb0460s00, searchAb0460s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0460s00 table.
	 * 
	 * filterAb0460s00 Ab0460s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean Object
	 * 
	 * @param filterAb0460s00
	 *            the filter ab 0460 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the object
	 */
	public Object reorderSelection(OS2 filterAb0460s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.os2Dao.reorderSelection(filterAb0460s00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Updates a single row in the Ab04b60s00 table.
	 * 
	 * comunicacionPrl ComunicacionPrl platea the platea OS2
	 * 
	 * @param comunicacionPrl
	 *            the comunicacion prl
	 * @param platea
	 *            the platea
	 * @return the os2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS2 modificarDatosTabNotificacionOS2(
			ComunicacionPrl comunicacionPrl, boolean platea) {

		// registrar historico cambios
		/*
		 * ComunicacionApertura comunicacionAperturaOld = this
		 * .findComunicAperturaConNotificacion(ab04b60s00); String
		 * comunicacionAperturaOldStr = HistCambiosAperturasUtil
		 * .concatenarCamposApertura("Datos notificación.",
		 * comunicacionAperturaOld); String comunicacionAperturaNewStr =
		 * HistCambiosAperturasUtil .concatenarCamposApertura(
		 * "Datos notificación.", ab04b60s00);
		 * 
		 * HistCambiosAperturas histCambioAperturas = new
		 * HistCambiosAperturas();
		 * histCambioAperturas.setIdape087(comunicacionAperturaOld.getIdape060()
		 * ); if (comunicacionAperturaOld.getMigrado060() != null &&
		 * Constantes.VALUE_SI.equals(comunicacionAperturaOld .getMigrado060()))
		 * { histCambioAperturas.setMigrado087(Constantes.HIST_MODIF_MIGRADO_A);
		 * } else {
		 * histCambioAperturas.setMigrado087(Constantes.HIST_MODIF_MIGRADO_N); }
		 * 
		 * histCambioAperturas.setRegoriginal087(comunicacionAperturaOldStr);
		 * histCambioAperturas.setRegmidificaciones087(
		 * comunicacionAperturaNewStr); histCambioAperturas.setFecmodif087(new
		 * Date());
		 * histCambioAperturas.setTipocambio087(TipoCambio.MODIFICACION_APERTURA
		 * .getCodigo());
		 * 
		 * this.histCambiosAperturasDao.add(histCambioAperturas);
		 */
		// Localización
		if (comunicacionPrl.getDatosNotificacion() != null
				&& comunicacionPrl.getDatosNotificacion().getCanalnotif066() != null
				&& comunicacionPrl.getDatosNotificacion().getCanalnotif066()
						.equals(Constantes.CANAL_NOTIF_POSTAL) && !platea) {
			DatosLocalizacion localizacion = comunicacionPrl
					.getDatosNotificacion().getDatosLocalizacion();
			if (localizacion.getCodLocalizacion067() != null) {
				// Los datos de localización existen. Los actualizamos
				this.datosLocalizacionService.update(localizacion);
			} else {
				// Los datos de localización no existen. Los insertamos
				localizacion = this.datosLocalizacionService.add(localizacion);
				comunicacionPrl.getDatosNotificacion().setDatosLocalizacion(
						localizacion);

			}
		}

		// Datos notificación
		if (comunicacionPrl.getDatosNotificacion() != null && !platea) {
			if (comunicacionPrl.getDatosNotificacion().getCanalnotif066() != null) {
				DatosLocalizacion datosLoc = comunicacionPrl
						.getDatosNotificacion().getDatosLocalizacion();
				if (comunicacionPrl.getDatosNotificacion().getCanalnotif066()
						.equals(Constantes.CANAL_NOTIF_TELEMATICO)) {
					comunicacionPrl.getDatosNotificacion()
							.setDatosLocalizacion(new DatosLocalizacion(null));
				}

				// Los datos de notificación existen. Los actualizamos
				this.datosNotificacionService.update(comunicacionPrl
						.getDatosNotificacion());
				if (comunicacionPrl.getDatosNotificacion().getCanalnotif066()
						.equals(Constantes.CANAL_NOTIF_TELEMATICO)) {
					this.datosLocalizacionService.remove(datosLoc);
				}

				OS2 os2 = OS2.convertComunicacionPrltoOS2(comunicacionPrl);

				os2 = this.os2Dao.modificarDatosTabNotificacionOS2(os2);

			} else {
				// Los datos de notificación no existen. Los insertamos
				DatosNotificacion datosNotif = this.datosNotificacionService
						.add(comunicacionPrl.getDatosNotificacion());
				comunicacionPrl.setDatosNotificacion(datosNotif);
				ComunicacionPrl prlDatosNotif = new ComunicacionPrl();
				prlDatosNotif.setTeros(comunicacionPrl.getTeros());
				prlDatosNotif.setAnoos(comunicacionPrl.getAnoos());
				prlDatosNotif.setNumos(comunicacionPrl.getNumos());

				prlDatosNotif.setDatosNotificacion(datosNotif);

				OS2 os2 = OS2.convertComunicacionPrltoOS2(comunicacionPrl);

				os2 = this.os2Dao.modificarDatosTabNotificacionOS2(os2);
			}
		} else {
			OS2 os2 = OS2.convertComunicacionPrltoOS2(comunicacionPrl);

			os2 = this.os2Dao.modificarDatosTabNotificacionOS2(os2);
		}

		return OS2.convertComunicacionPrltoOS2(comunicacionPrl);
	}

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS2 modificarDatosTabEmpresaOS2(OS2 os2) {
		return this.os2Dao.modificarDatosTabEmpresaOS2(os2);
	}

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS2 modificarDatosTabModalidad(OS2 os2) {
		return this.os2Dao.modificarDatosTabModalidad(os2);
	}

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS2 modificarDatosTabAuditoria(OS2 os2) {
		return this.os2Dao.modificarDatosTabAuditoria(os2);
	}

	/**
	 * Updates a single row in the Ab0460s00 table.
	 * 
	 * os2 OS2 OS2
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	@Transactional(rollbackFor = Throwable.class)
	public OS2 modificarDatosTabEstadoOS2(OS2 os2) {
		return this.os2Dao.modificarDatosTabEstadoOS2(os2);
	}

	/**
	 * Finds a single row in the Ab04b60s00 table.
	 * 
	 * folderId String Ab04b60s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the os2
	 */
	public OS2 findByFolderId(String folderId) {
		return (OS2) this.os2Dao.findByFolderId(folderId);
	}

	/**
	 * Finds a single row in the Ab04b60s00 table.
	 * 
	 * folderId String Ab04b60s00
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the os2
	 */
	public OS2 findByFolderId2(String folderId) {
		return (OS2) this.os2Dao.findByFolderId2(folderId);
	}

	/**
	 * Busca los datos de registro.
	 * 
	 * os2 the os 2 ComunicacionApertura
	 * 
	 * @param os2
	 *            the os 2
	 * @return the os2
	 */
	public OS2 findDatosRegistro(OS2 os2) {
		return this.os2Dao.findDatosRegistro(os2);
	}

	/**
	 * Crea un registro con los datos minimos.
	 * 
	 * OS2
	 * 
	 * @param aux
	 *            the aux
	 * @return the os2
	 */
	public OS2 altaComunicacionOS2Presencial(OS2 aux) {

		OS2 os2 = new OS2();
		List<ErrorField> errores = new ArrayList<ErrorField>();

		if (aux.getDeseaRegistrar060() != null) {
			if ("S".equals(aux.getDeseaRegistrar060())) {
				os2.setDeseaRegistrar060(aux.getDeseaRegistrar060());
				os2.setNumReg060("");
				os2.setFecReg060(null);
			} else if ("N".equals(aux.getDeseaRegistrar060())) {
				os2.setDeseaRegistrar060(aux.getDeseaRegistrar060());
				if (aux.getNumReg060() != null) {
					os2.setNumReg060(aux.getNumReg060());
				} else {
					os2.setNumReg060("");
					errores.add(new ErrorField("aperturas.detalle.numReg",
							"validacion.obligatorio"));
				}
				if (aux.getFecReg060() != null) {
					os2.setFecReg060(aux.getFecReg060());
				} else {
					os2.setFecReg060(null);
					errores.add(new ErrorField("aperturas.detalle.fecReg",
							"validacion.obligatorio"));
				}
			}
		} else {
			os2.setNumReg060("");
			os2.setFecReg060(null);
			errores.add(new ErrorField("aperturas.detalle.deseaRegistrar",
					"validacion.obligatorio"));
		}

		if (aux.getTipdoc060() != null) {
			os2.setTipdoc060(aux.getTipdoc060());
		} else {
			errores.add(new ErrorField("comunicacionPrl.tipoidentif",
					"validacion.obligatorio"));
		}
		if (aux.getNumdoc060() != null) {
			os2.setNumdoc060(aux.getNumdoc060());
		} else {
			errores.add(new ErrorField("comunicacionPrl.numdoc",
					"validacion.obligatorio"));
		}
		if (aux.getNomemp060() != null) {
			os2.setNomemp060(aux.getNomemp060());
		} else {
			errores.add(new ErrorField("comunicacionPrl.nombreEmpresa",
					"validacion.obligatorio"));
		}

		if (aux.getAnoos2060() == null) {
			aux.setAnoos2060(new SimpleDateFormat(Constantes.DATE_PATTERN_YEAR)
					.format(new Date()));
		} else {
			os2.setAnoos2060(aux.getAnoos2060());
		}

		if (aux.getTeros2060() == null) {
			os2.setTeros2060(UtilSeguridad.getInstance()
					.obtenerDelegacionUsuario());
		} else {
			os2.setTeros2060(aux.getTeros2060());
		}

		NumeracionExpediente numApe = null;
		boolean existe = false;
		OS2 os2Aux = new OS2();
		if (aux.getNumos2060() != null) {
			os2.setNumos2060(aux.getNumos2060());
			os2Aux.setTeros2060(os2.getTeros2060());
			os2Aux.setAnoos2060(os2.getAnoos2060());
			os2Aux.setNumos2060(os2.getNumos2060());
			existe = this.os2Dao.findAllCount(os2Aux) > 0;
			if (existe) {
				errores.add(0, new ErrorField("aperturas.nexp",
						"error.existenumape"));

				if (!errores.isEmpty()) {
					throw new ErrorGenericoException(errores);
				}
			}
		} else if (!errores.isEmpty()) {
			throw new ErrorGenericoException(errores);
		} else {
			boolean libre = false;
			while (!libre) {
				numApe = new NumeracionExpediente();
				numApe.setTerexp075(os2.getTeros2060());
				numApe.setAnoexp075(os2.getAnoos2060());
				numApe.setTipexp075(TipoExpedienteFolderEnum.OS2
						.getIdTipoExpediente().toString());

				// obtenemos el numero de apertura
				os2.setNumos2060(this.numeracionExpedienteDao
						.obtenerNumExpSiguiente(numApe).intValue());

				os2Aux.setTeros2060(os2.getTeros2060());
				os2Aux.setAnoos2060(os2.getAnoos2060());
				os2Aux.setNumos2060(os2.getNumos2060());
				if (this.os2Dao.findAllCount(os2Aux) == 0) {
					libre = true;
				} else {
					// actualizar numero de apertura
					this.numeracionExpedienteDao
							.actualizarNumExpSiguiente(numApe);
				}
			}

		}

		// Realizamos las inserciones en orden

		// Añadimos la OS2
		os2 = this.os2Dao.addPresencial(os2);

		os2.setDatosNotificacion(new DatosNotificacion());
		os2.getDatosNotificacion().setCanalnotif066(
				Constantes.CANAL_NOTIF_TELEMATICO);
		if (Constantes.LOCALE_ES.equals(LocaleContextHolder.getLocale())) {
			os2.getDatosNotificacion().setIdioma066(
					Constantes.IDIOMA_NOTIF_CASTELLANO);
		} else if (Constantes.LOCALE_EU.equals(LocaleContextHolder.getLocale())) {
			os2.getDatosNotificacion().setIdioma066(
					Constantes.IDIOMA_NOTIF_EUSKERA);
		}
		os2.getDatosNotificacion()
				.setDatosLocalizacion(new DatosLocalizacion());

		// Los datos de notificación no existen. Los insertamos
		DatosNotificacion datosNotif = this.datosNotificacionService.add(os2
				.getDatosNotificacion());
		os2.setDatosNotificacion(datosNotif);

		this.os2Dao.modificarDatosTabNotificacionOS2(os2);

		if (aux.getNumos2060() == null) {
			// actualizar numero de apertura
			this.numeracionExpedienteDao.actualizarNumExpSiguiente(numApe);
		}

		return os2;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.OS2Service#updateFilled(com.ejie.ab04b.model.OS2)
	 */
	@Override
	public OS2 updateFilled(OS2 os2) {
		return this.os2Dao.updateFilled(os2);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.OS2Service#modificarDatosRegistro(com.ejie.ab04b.
	 * model.OS2)
	 */
	@Override
	public OS2 modificarDatosRegistro(OS2 os2_reg) {
		return this.os2Dao.modificarDatosRegistro(os2_reg);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.OS2Service#updateUsuariosTramitacion(com.ejie.
	 * ab04b.model.OS2)
	 */
	@Override
	public void updateUsuariosTramitacion(OS2 os2) {
		this.os2Dao.updateUsuariosTramitacion(os2);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.ab04b.service.OS2Service#updateEstado(com.ejie.ab04b.model.OS2)
	 */
	@Override
	public void updateEstado(OS2 os2) {
		this.os2Dao.updateEstado(os2);

	}

	@Override
	public void updateBatchSub(OS2 os2) {
		this.os2Dao.updateBatchSub(os2);

	}

	@Override
	public void updateFecSub(OS2 os2) {
		this.os2Dao.updateFecSub(os2);

	}

	/**
	 * Obtener documentos migrados.
	 * 
	 * @param folderId
	 *            the folder id
	 * @return the folder document list
	 */
	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.ab04b.service.ComunicacionAperturaService#
	 * obtenerDocumentosMigrados(java.lang.String)
	 */
	@Override()
	public FolderDocumentList obtenerDocumentosMigrados(String folderId) {
		return reeService.obtenerDocumentosMigrados(folderId);
	}
}
